function save_file(test_data, Score, groundtruth, feature_num)
% SAVE_FILE Save prediction results to an Excel file.
%
% Inputs:
%   test_data     - Test dataset.
%   Score         - Predicted scores/probabilities for each class.
%   groundtruth   - Ground truth labels, or a placeholder (-1.532) if unavailable.
%   feature_num   - Number of features (used to generate headers).

    % Save output matrix:
    % If groundtruth is not provided (equals -1.532), use all columns of test_data.
    % Otherwise, exclude the last column (assumed to be groundtruth).
    if groundtruth == -1.532
        A = [test_data(:,1:end), Score];  % Append scores to all test data
    else
        A = [test_data(:,1:end-1), Score]; % Append scores to test data excluding groundtruth
    end

    % Create column headers for Excel (e.g., x1, x2, ..., xN, Score0, Score1, Score2)
    headers = cell(1, feature_num + 3);  % +3 for the 3 score columns
    for i = 1:feature_num
        headers(i) = {"x" + num2str(i,'%d')};  % Feature headers: x1, x2, ...
    end

    % Append headers for score columns (assuming 3-class classification)
    headers(feature_num + 1) = {"Score0"};
    headers(feature_num + 2) = {"Score1"};
    headers(feature_num + 3) = {"Score2"};

    % Combine headers and data
    A = [headers; num2cell(A)];

    % Construct file path to save: /output_bayes/result_bayes.xlsx
    root = find_root();  % Get project root path
    fn = fullfile(root, 'output_bayes', 'result_bayes.xlsx');  % Full path for saving

    % Write to Excel file
    xlswrite(fn, A);

    % Display confirmation message
    disp('Save completed.')
    fprintf(' %s \n', fn);
end
